/***************************************************************************
 *
 * Copyright 2010,2011 BMW Car IT GmbH
 * Copyright (C) 2011 DENSO CORPORATION and Robert Bosch Car Multimedia Gmbh
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/
#ifndef __CONFIG_H__
#define __CONFIG_H__

/*
 Auto-generated. Do not modify.
 Variables configured by CMake build system
*/

/*
-----------------------------------------------------------------------------
 string variables
-----------------------------------------------------------------------------
*/
/* version of the LayerManagementService */
#define ILM_VERSION          "1.1.0.release+J52_G3_MC0_HF2448"

#define LAYERMANAGER_MAJOR_VERSION	"1"
#define LAYERMANAGER_MINOR_VERSION	"1"
#define LAYERMANAGER_PATCH_LEVEL	"0"
/* CMake build type, e.g. Debug, Release */
#define CMAKE_BUILD_TYPE     "Release"

/* compiler flags used to build project */
#define CMAKE_CXX_FLAGS      "-march=armv7-a -mfloat-abi=softfp -mfpu=neon -mtune=cortex-a9 --no-sysroot-suffix  --sysroot=/baseint_home/work/slave/gen3-21_2S/RFS_BUILD_gen3_integration/imx6_build/oe-MGC_20151201-mx6q/build/tmp/sysroots/mx6q  -O2 -pipe -g -feliminate-unused-debug-types -fvisibility-inlines-hidden"

/* install prefix of target platform */
#define CMAKE_INSTALL_PREFIX "/usr"

/*
-----------------------------------------------------------------------------
 build flags
-----------------------------------------------------------------------------
*/
/* Force Software Copy of Pixmaps (compatibility for VMs) */
/* #undef WITH_FORCE_COPY */
 
/* Input handling via xcb */
/* #undef XCB_EVENT_HANDLING */
 
/* EGL/GLES 2.0 Wayland Renderer / Compositor Plug In */
#define WITH_WAYLAND
 
/* enable MX6Q IMX FSL Vivante compiler settings */
#define WITH_IMX
 
/* add smoketest and systemd */
#define WITH_ADIT_SYSTEMD_TEST
 
/* Report styleguide problems during build (requires python) */
/* #undef WITH_STYLE_CHECKING */
 
/* Generate documentation during build (requires doxygen) */
/* #undef WITH_DOCUMENTATION */
 
/* Run cppcheck during build (requires cppcheck) */
/* #undef WITH_CPPCHECK */
 
/* Build unit test binaries for all enabled components */
/* #undef WITH_TESTS */
 
/* Build examples for GLES/X11 based platforms */
/* #undef WITH_EGL_EXAMPLE */
 
/* Build examples for OpenGL/X11 based platforms */
/* #undef WITH_GLX_EXAMPLE */
 
/* Build examples for client library usage */
#define WITH_CLIENTEXAMPLES
 
/* Build examples for GLES/Wayland based platforms */
#define WITH_WL_EXAMPLE
 
/* Build examples for Color Space Conversion */
/* #undef WITH_IPUDPCSC_EXAMPLE */
 
/* Build LayerManagerControl binary */
#define WITH_CONTROL_BIN
 
/* Build scene provider plugin to run example applications */
/* #undef WITH_EXAMPLE_SCENE_PROVIDER */
 
/* Build configurator plugin to set configuration at run time */
/* #undef WITH_EXAMPLE_CONFIGURATOR */
 
/* Build plugin for systemd based health monitoring */
/* #undef WITH_SYSTEMD_HEALTH_MONITOR */
 
/* Build Generic Communicator Plugin based on IpcModules */
#define WITH_GENERIC_COMMUNICATOR
 
/* Build renderer plugin for OpenGL/X11 based platforms */
/* #undef WITH_DESKTOP */
 
/* Build development library for OpenGL/X11 based renderers */
/* #undef WITH_GLX_LIB */
 
/* Build renderer plugin for GLES/Wayland with X11 backend */
/* #undef WITH_WAYLAND_X11 */
 
/* Build development library for GLES/Wayland X11 based renderers */
/* #undef WITH_WAYLAND_X11_LIB */
 
/* Build renderer plugin for GLES/Wayland with DRM backend */
/* #undef WITH_WAYLAND_DRM */
 
/* Build development library for GLES/Wayland DRM based renderers */
/* #undef WITH_WAYLAND_DRM_LIB */
 
/* Build renderer plugin for GLES/Wayland with FBDEV backend */
/* #undef WITH_WAYLAND_FBDEV */
 
/* Build development library for GLES/Wayland FBDEV based renderers */
/* #undef WITH_WAYLAND_FBDEV_LIB */
 
/* Build renderer plugin for Wayland with Vivante GAL2D backend */
#define WITH_WAYLAND_GAL2D
 
/* Build development library for Wayland Vivante GAL2D based renderers */
/* #undef WITH_WAYLAND_GAL2D_LIB */
 
/* Build renderer plugin for GLES/X11 based platforms */
/* #undef WITH_X11_GLES */
 
/* Build development library for GLES/X11 based renderers */
/* #undef WITH_GLESv2_LIB */
 
/* Build renderer plugin with pure logging (no rendering) */
/* #undef WITH_TEXT_RENDERER */
 
/* Build LayerManagerService binary */
#define WITH_SERVICE_BIN
 
/* Build LayerManagement client library */
#define WITH_CLIENT_LIB
 
/* Build LayerManagement control library */
#define WITH_CONTROL_LIB
 
/* Build LayerManagement calibration client library */
#define WITH_CALIBRATION_CLIENT_LIB
 
/* Build with DLT logging support */
#define WITH_DLT
 
/* Link all plugins and libraries statically */
/* #undef WITH_STATIC_LIBRARIES */
 
/* Build with systemd sync startup for wayland window systems */
#define WITH_WAYLAND_SYSTEMD_SYNC
 
/* Build calibration feature */
#define WITH_CALIBRATION
 
/* Build examples for parsing device configuration files */
#define WITH_DEVICE_CONFIG_PARSER_EXAMPLE
 
/* Build examples for checking lookup behaviour */
#define WITH_DEVICE_SUBDIVISION_LOOKUP_EXAMPLE
 
/* Build examples for checking subdivisions with Wayland */
#define WITH_WAYLAND_SUBDIVISION_EXAMPLE
 
/* Build examples for using calibration to translate coordinates */
#define WITH_CALIBRATION_TRANSLATION_EXAMPLE
 
/* Build logging with Mutex locks */
#define WITH_LOG_MUTEX
 
/* platform support for backtrace command */
#define HAVE_BACKTRACE
 
/* platform has execinfo.h header file */
#define HAVE_EXECINFO_H
 
/* Build tests for the Matrix class of the LayerManagerCalibration library */
#define WITH_MATRIX_TEST
 
/* Build test for coefficient derivation in the LayerManagerCalibration library */
#define WITH_COEFFICIENT_TEST
 
/* Install integration test scripts */
#define WITH_INTEGRATION_TESTS
 
/* Install test for logging */
#define WITH_LOG_TESTS
 
/* Build Example of wayland shared memory */
#define WITH_WAYLAND_SHM_EXAMPLE
 
/* Build tool to compare dumps pixel-by-pixel within tolerances */
#define WITH_PIXEL_DIFF_TOOL
 


/*
-----------------------------------------------------------------------------
 human readable report
-----------------------------------------------------------------------------
*/
#define DEBUG_FLAG 1
#define INFO_FLAG  2

typedef struct
{
    int type;
    const char* description;
} BuildFlag;

const BuildFlag gBuildFlags[] =
{
    { INFO_FLAG,  "Build Version         = 1.1.0.release+J52_G3_MC0_HF2448" },
    { DEBUG_FLAG, "Build Type            = Release" },

    { DEBUG_FLAG, "HAVE_BACKTRACE = 1" },
    { DEBUG_FLAG, "HAVE_EXECINFO_H = 1" },
    { DEBUG_FLAG, "WITH_ADIT_SYSTEMD_TEST = ON" },
    { DEBUG_FLAG, "WITH_CALIBRATION = ON" },
    { DEBUG_FLAG, "WITH_CALIBRATION_CLIENT_LIB = ON" },
    { DEBUG_FLAG, "WITH_CALIBRATION_TRANSLATION_EXAMPLE = ON" },
    { DEBUG_FLAG, "WITH_CLIENTEXAMPLES = ON" },
    { DEBUG_FLAG, "WITH_CLIENT_LIB = ON" },
    { DEBUG_FLAG, "WITH_COEFFICIENT_TEST = ON" },
    { DEBUG_FLAG, "WITH_CONTROL_BIN = ON" },
    { DEBUG_FLAG, "WITH_CONTROL_LIB = ON" },
    { DEBUG_FLAG, "WITH_CPPCHECK = OFF" },
    { DEBUG_FLAG, "WITH_DESKTOP = OFF" },
    { DEBUG_FLAG, "WITH_DEVICE_CONFIG_PARSER_EXAMPLE = ON" },
    { DEBUG_FLAG, "WITH_DEVICE_SUBDIVISION_LOOKUP_EXAMPLE = ON" },
    { DEBUG_FLAG, "WITH_DLT = ON" },
    { DEBUG_FLAG, "WITH_DOCUMENTATION = OFF" },
    { DEBUG_FLAG, "WITH_EGL_EXAMPLE = OFF" },
    { DEBUG_FLAG, "WITH_EXAMPLE_CONFIGURATOR = OFF" },
    { DEBUG_FLAG, "WITH_EXAMPLE_SCENE_PROVIDER = OFF" },
    { DEBUG_FLAG, "WITH_FORCE_COPY = OFF" },
    { DEBUG_FLAG, "WITH_GENERIC_COMMUNICATOR = ON" },
    { DEBUG_FLAG, "WITH_GLESv2_LIB = OFF" },
    { DEBUG_FLAG, "WITH_GLX_EXAMPLE = OFF" },
    { DEBUG_FLAG, "WITH_GLX_LIB = OFF" },
    { DEBUG_FLAG, "WITH_IMX = ON" },
    { DEBUG_FLAG, "WITH_INTEGRATION_TESTS = ON" },
    { DEBUG_FLAG, "WITH_IPUDPCSC_EXAMPLE = OFF" },
    { DEBUG_FLAG, "WITH_LOG_MUTEX = ON" },
    { DEBUG_FLAG, "WITH_LOG_TESTS = ON" },
    { DEBUG_FLAG, "WITH_MATRIX_TEST = ON" },
    { DEBUG_FLAG, "WITH_PIXEL_DIFF_TOOL = ON" },
    { DEBUG_FLAG, "WITH_SERVICE_BIN = ON" },
    { DEBUG_FLAG, "WITH_STATIC_LIBRARIES = OFF" },
    { DEBUG_FLAG, "WITH_STYLE_CHECKING = OFF" },
    { DEBUG_FLAG, "WITH_SYSTEMD_HEALTH_MONITOR = OFF" },
    { DEBUG_FLAG, "WITH_TESTS = OFF" },
    { DEBUG_FLAG, "WITH_TEXT_RENDERER = OFF" },
    { DEBUG_FLAG, "WITH_WAYLAND = ON" },
    { DEBUG_FLAG, "WITH_WAYLAND_DRM = OFF" },
    { DEBUG_FLAG, "WITH_WAYLAND_DRM_LIB = OFF" },
    { DEBUG_FLAG, "WITH_WAYLAND_FBDEV = OFF" },
    { DEBUG_FLAG, "WITH_WAYLAND_FBDEV_LIB = OFF" },
    { DEBUG_FLAG, "WITH_WAYLAND_GAL2D = ON" },
    { DEBUG_FLAG, "WITH_WAYLAND_GAL2D_LIB = OFF" },
    { DEBUG_FLAG, "WITH_WAYLAND_SHM_EXAMPLE = ON" },
    { DEBUG_FLAG, "WITH_WAYLAND_SUBDIVISION_EXAMPLE = ON" },
    { DEBUG_FLAG, "WITH_WAYLAND_SYSTEMD_SYNC = ON" },
    { DEBUG_FLAG, "WITH_WAYLAND_X11 = OFF" },
    { DEBUG_FLAG, "WITH_WAYLAND_X11_LIB = OFF" },
    { DEBUG_FLAG, "WITH_WL_EXAMPLE = ON" },
    { DEBUG_FLAG, "WITH_X11_GLES = OFF" },
    { DEBUG_FLAG, "XCB_EVENT_HANDLING = OFF" },

    { DEBUG_FLAG, "Install Prefix        = /usr" }
};

const int gBuildFlagCount = sizeof(gBuildFlags) / sizeof(gBuildFlags[0]);

/*
-----------------------------------------------------------------------------
 manage list of statically linked plugins
-----------------------------------------------------------------------------
*/
#define REGISTER_PLUGIN(PLUGIN) \
    extern "C" IPlugin* create ## PLUGIN(ICommandExecutor& executor, Configuration& config); \
    static bool PLUGIN ## _instance = PluginManager::registerStaticPluginCreateFunction(create ## PLUGIN);

#define STATIC_PLUGIN_REGISTRATION 

/*
-----------------------------------------------------------------------------
 define plugin entry point depending on build settings
-----------------------------------------------------------------------------
*/
#define DECLARE_LAYERMANAGEMENT_PLUGIN(name) \
extern "C" IPlugin* create ## name(ICommandExecutor& executor, Configuration& config) \
{ \
    return new name(executor, config); \
}

#endif /* __CONFIG_H__ */
